/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.destination.JeusTemporaryQueue;
import jeus.jms.common.destination.JeusTemporaryTopic;
import jeus.jms.common.destination.TemporaryDestination;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.DataSqueezer;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.MessageRecoveryListener;
import jeus.jms.server.persistence.database.DatabaseCursor;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class RecoverMessageCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "RECOVER_MESSAGE";
    private MessageRecoveryListener listener;
    private static String userPropertySQL;

    public RecoverMessageCommand(DatabaseStorage storage, MessageRecoveryListener listener) {
        super(storage);
        this.listener = listener;
    }

    protected String createSQL() {
        if (userPropertySQL == null) {
            StringBuffer upBuffer = new StringBuffer();
            upBuffer.append("SELECT ");
            upBuffer.append("UP_NAME").append(", ");
            upBuffer.append("UP_TYPE").append(", ");
            upBuffer.append("UP_BOOLEAN").append(", ");
            upBuffer.append("UP_BYTE").append(", ");
            upBuffer.append("UP_SHORT").append(", ");
            upBuffer.append("UP_INT").append(", ");
            upBuffer.append("UP_LONG").append(", ");
            upBuffer.append("UP_FLOAT").append(", ");
            upBuffer.append("UP_DOUBLE").append(", ");
            upBuffer.append("UP_STRING");
            upBuffer.append(" FROM ").append(this.storage.getUserPropertyTableName());
            upBuffer.append(" WHERE ").append("MG_ID").append("=?");
            userPropertySQL = upBuffer.toString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ");
        buffer.append("MG_ID").append(", ");
        buffer.append("DT_ID").append(", ");
        buffer.append("MG_MESSAGE_TYPE").append(", ");
        buffer.append("MG_STATUS").append(", ");
        buffer.append("MG_BROKER_ID").append(", ");
        buffer.append("MG_ENTRY_ID").append(", ");
        buffer.append("MG_CONNECTION_ID").append(", ");
        buffer.append("MG_SEQUENCE").append(", ");
        buffer.append("MG_META_INFO").append(", ");
        buffer.append("MG_CORRELATION_ID").append(", ");
        buffer.append("MG_TD_REPLY_TO").append(", ");
        buffer.append("MG_TD_TYPE").append(", ");
        buffer.append("MG_TD_BROKER_NAME").append(", ");
        buffer.append("MG_TD_NAME").append(", ");
        buffer.append("MG_TD_CONNECTION_ID").append(", ");
        buffer.append("MG_REPLY_TO").append(", ");
        buffer.append("MG_DELIVERY_MODE").append(", ");
        buffer.append("MG_TYPE").append(", ");
        buffer.append("MG_PRIORITY").append(", ");
        buffer.append("MG_EXPIRATION").append(", ");
        buffer.append("MG_TIMESTAMP").append(", ");
        buffer.append("MG_SCHEDULE").append(", ");
        buffer.append("MG_REDELIVERY_LIMIT").append(", ");
        buffer.append("MG_HAS_LONG_USER_PROPS").append(", ");
        buffer.append("MG_USER_PROPERTIES").append(", ");
        buffer.append("MG_LIFECYCLE").append(", ");
        buffer.append("MG_VERSION");
        buffer.append(" FROM ").append(this.storage.getMessageTableName());
        buffer.append(" ORDER BY ").append("MG_PRIORITY").append(" DESC, ").append("MG_TIMESTAMP").append(" ASC");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet rs = null;
        try {
            if (this.listener != null) {
                this.listener.beginRecovery();
            }
            stmt.setFetchSize(JMSProperties.ROW_FETCH_SIZE);
            rs = stmt.executeQuery(this.getSQL());
            while (rs.next()) {
                long id = rs.getLong("MG_ID");
                long destinationId = rs.getLong("DT_ID");
                byte lifecycle = rs.getByte("MG_LIFECYCLE");
                boolean hasLongUserProps = rs.getBoolean("MG_HAS_LONG_USER_PROPS");
                MetaHeader header = new MetaHeader(rs.getByte("MG_MESSAGE_TYPE"));
                MessageID msgID = new MessageID(rs.getShort("MG_BROKER_ID"), rs.getLong("MG_ENTRY_ID"), rs.getInt("MG_CONNECTION_ID"), rs.getInt("MG_SEQUENCE"));
                msgID.setStatus(rs.getByte("MG_STATUS"));
                DatabaseCursor cursor = new DatabaseCursor(this.storage, id);
                ServerMessage msg = new ServerMessage(header, cursor);
                msg.setId(id);
                msg.setMessageID(msgID);
                msg.setMetaInfo(rs.getInt("MG_META_INFO"));
                msg.setJMSCorrelationID(rs.getString("MG_CORRELATION_ID"));
                long replyTo = rs.getLong("MG_REPLY_TO");
                long tdReplyTo = rs.getLong("MG_TD_REPLY_TO");
                if (replyTo >= 0L && DestinationUtil.checkDestination(replyTo)) {
                    DestinationManager destinationManager = DestinationUtil.getDestinationManager(replyTo);
                    msg.setJMSReplyTo(destinationManager.getDestination());
                } else if (tdReplyTo > 0L) {
                    byte tdType = rs.getByte("MG_TD_TYPE");
                    String tdBrokerName = rs.getString("MG_TD_BROKER_NAME");
                    String tdLocalName = rs.getString("MG_TD_NAME");
                    int tdConnectionId = rs.getInt("MG_TD_CONNECTION_ID");
                    TemporaryDestination td = tdType == 113 ? new JeusTemporaryQueue(tdBrokerName, tdLocalName, tdReplyTo, tdConnectionId) : new JeusTemporaryTopic(tdBrokerName, tdLocalName, tdReplyTo, tdConnectionId);
                    msg.setJMSReplyTo(td);
                }
                msg.setJMSDeliveryMode(rs.getInt("MG_DELIVERY_MODE"));
                msg.setJMSType(rs.getString("MG_TYPE"));
                msg.setJMSPriority(rs.getInt("MG_PRIORITY"));
                msg.setJMSExpiration(rs.getLong("MG_EXPIRATION"));
                msg.setJMSTimestamp(rs.getLong("MG_TIMESTAMP"));
                msg.setScheduledTime(rs.getLong("MG_SCHEDULE"));
                msg.setRedeliveryLimit(rs.getInt("MG_REDELIVERY_LIMIT"));
                if (hasLongUserProps) {
                    this.setUserProperties(connection, msg);
                } else {
                    this.setUserProperties(rs.getString("MG_USER_PROPERTIES"), msg);
                }
                long version = rs.getLong("MG_VERSION");
                if (this.listener == null) continue;
                this.listener.recovered(id, destinationId, version, msg, lifecycle);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserProperties(Connection conn, ServerMessage message) throws Exception {
        block18: {
            PreparedStatement stmt = conn.prepareStatement(userPropertySQL);
            stmt.setFetchSize(JMSProperties.ROW_FETCH_SIZE);
            stmt.setLong(1, message.getId());
            ResultSet rs = stmt.executeQuery();
            block15: while (true) {
                while (rs.next()) {
                    String name = rs.getString("UP_NAME");
                    byte type = rs.getByte("UP_TYPE");
                    try {
                        switch (type) {
                            case 2: {
                                message.setBooleanProperty(name, rs.getBoolean("UP_BOOLEAN"));
                                break;
                            }
                            case 3: {
                                message.setByteProperty(name, rs.getByte("UP_BYTE"));
                                break;
                            }
                            case 8: {
                                message.setShortProperty(name, rs.getShort("UP_SHORT"));
                                break;
                            }
                            case 1: {
                                message.setIntProperty(name, rs.getInt("UP_INT"));
                                break;
                            }
                            case 7: {
                                message.setLongProperty(name, rs.getLong("UP_LONG"));
                                break;
                            }
                            case 4: {
                                message.setFloatProperty(name, rs.getFloat("UP_FLOAT"));
                                break;
                            }
                            case 5: {
                                message.setDoubleProperty(name, rs.getDouble("UP_DOUBLE"));
                                break;
                            }
                            case 6: {
                                message.setStringProperty(name, rs.getString("UP_STRING"));
                                break;
                            }
                        }
                        continue block15;
                    }
                    catch (JMSException jmsEx) {
                        jmsEx.printStackTrace();
                    }
                }
                break block18;
                {
                    continue block15;
                    break;
                }
                break;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                stmt.close();
            }
        }
    }

    private void setUserProperties(String userProps, ServerMessage message) {
        if (userProps == null || userProps.length() == 0) {
            return;
        }
        DataSqueezer squeezer = this.storage.getDataSqueezer();
        StringTokenizer stk = new StringTokenizer(userProps, ":");
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            int comma = token.indexOf(44);
            String name = (String)squeezer.unsqueeze(token.substring(0, comma));
            Object value = squeezer.unsqueeze(token.substring(comma + 1));
            try {
                if (value instanceof String) {
                    message.setStringProperty(name, (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    message.setBooleanProperty(name, (Boolean)value);
                    continue;
                }
                if (value instanceof Byte) {
                    message.setByteProperty(name, (Byte)value);
                    continue;
                }
                if (value instanceof Short) {
                    message.setShortProperty(name, (Short)value);
                    continue;
                }
                if (value instanceof Integer) {
                    message.setIntProperty(name, (Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    message.setLongProperty(name, (Long)value);
                    continue;
                }
                if (value instanceof Float) {
                    message.setFloatProperty(name, ((Float)value).floatValue());
                    continue;
                }
                if (!(value instanceof Double)) continue;
                message.setDoubleProperty(name, (Double)value);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

