/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.persistence.XARecoveryListener;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class RecoverXACommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "RECOVER_XA_COMMAND";
    private XARecoveryListener listener;
    private Set inDoubtXids;

    public RecoverXACommand(DatabaseStorage storage, XARecoveryListener listener, Set inDoubtXids) {
        super(storage);
        this.listener = listener;
        this.inDoubtXids = inDoubtXids;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ").append("XA_ID").append(", ").append("XA_STARTTIME").append(", ");
        buffer.append("XA_PREPARED").append(", ").append("XA_XID");
        buffer.append(" FROM ").append(this.storage.getXATableName());
        buffer.append(" ORDER BY ").append("XA_STARTTIME").append(" ASC");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        Statement stmt = connection.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(this.getSQL());
            while (rs.next()) {
                JMSXid xid = new JMSXid(rs.getBytes("XA_XID"));
                boolean prepared = rs.getBoolean("XA_PREPARED");
                if (!prepared && !this.inDoubtXids.contains(xid)) {
                    this.listener.completed(xid);
                    continue;
                }
                if (this.inDoubtXids.contains(xid)) {
                    this.listener.prepared(xid);
                    continue;
                }
                this.listener.completed(xid);
            }
        }
        finally {
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

