/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.List;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.destination.JeusQueue;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class UpdateDestinationCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "UPDATE_DESTINATION";
    private JeusDestination destination;

    public UpdateDestinationCommand(DatabaseStorage storage, JeusDestination destination) {
        super(storage);
        this.destination = destination;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(this.storage.getDestinationTableName()).append(" SET ");
        buffer.append("DT_NAME").append("=?, ");
        buffer.append("DT_EXPORT_NAME").append("=?, ");
        buffer.append("DT_TYPE").append("=?, ");
        buffer.append("DT_BROKER_NAME").append("=?, ");
        buffer.append("DT_CONSUMER_LIMIT").append("=?, ");
        buffer.append("DT_CAPACITY_LOW_MARK").append("=?, ");
        buffer.append("DT_CAPACITY_HIGH_MARK").append("=?, ");
        buffer.append("DT_CAPACITY_LIMIT").append("=?, ");
        buffer.append("DT_MAX_PENDING_LIMIT").append("=?, ");
        buffer.append("DT_RESUME_DISPATCH_FACTOR").append("=?, ");
        buffer.append("DT_WEIGHT").append("=?, ");
        buffer.append("DT_DISTRIBUTE_TYPE").append("=?, ");
        buffer.append("DT_LOCAL_DISTRIBUTE_TYPE").append("=?, ");
        buffer.append("DT_MULTIPLE_RECEIVER").append("=?, ");
        buffer.append("DT_RELAY_TYPE").append("=?, ");
        buffer.append("DT_RELAYS").append("=?, ");
        buffer.append("DT_VALID").append("=?, ");
        buffer.append("DT_VERSION").append("=? WHERE ");
        buffer.append("DT_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_ID", String.valueOf(this.destination.getId())), new SQLParameter("DT_NAME", this.destination.getLocalName()), new SQLParameter("DT_EXPORT_NAME", this.destination.getExportName()), new SQLParameter("DT_TYPE", String.valueOf(this.destination.getType())), new SQLParameter("DT_VERSION", String.valueOf(this.destination.getVersion()))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setString(1, this.destination.getLocalName());
            stmt.setString(2, this.destination.getExportName());
            stmt.setByte(3, this.destination.getType());
            stmt.setString(4, this.destination.getBrokerName());
            stmt.setInt(5, this.destination.getConsumerLimit());
            stmt.setLong(6, this.destination.getLowMark());
            stmt.setLong(7, this.destination.getHighMark());
            stmt.setLong(8, this.destination.getLimit());
            stmt.setInt(9, this.destination.getMaxPendingLimit());
            stmt.setFloat(10, this.destination.getResumeDispatchFactor());
            if (this.destination.getType() == 81) {
                JeusQueue queue = (JeusQueue)this.destination;
                stmt.setInt(11, queue.getPreference());
                stmt.setByte(12, queue.getDistributeType());
                stmt.setByte(13, queue.getLocalDistributeType());
                stmt.setBoolean(14, queue.isPermitMultipleReceiver());
                stmt.setByte(15, queue.getRelayType());
                List relayList = queue.getRelays();
                if (relayList != null && !relayList.isEmpty()) {
                    StringBuffer buf = new StringBuffer();
                    Iterator i = relayList.iterator();
                    while (i.hasNext()) {
                        String relay = (String)i.next();
                        buf.append(relay);
                        if (!i.hasNext()) continue;
                        buf.append(",");
                    }
                    stmt.setString(16, buf.toString());
                } else {
                    stmt.setString(16, null);
                }
            } else {
                stmt.setInt(11, 1);
                stmt.setByte(12, (byte)0);
                stmt.setByte(13, (byte)0);
                stmt.setBoolean(14, false);
                stmt.setByte(15, (byte)0);
                stmt.setString(16, null);
            }
            stmt.setBoolean(17, true);
            stmt.setLong(18, this.destination.getVersion());
            stmt.setLong(19, this.destination.getId());
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

