/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class UpdateDestinationVersionCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "UPDATE_DESTINATION_VERSION";
    private long version;
    private long id;

    public UpdateDestinationVersionCommand(DatabaseStorage storage, long id, long version) {
        super(storage);
        this.version = version;
        this.id = id;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(this.storage.getDestinationTableName()).append(" SET ");
        buffer.append("DT_VERSION").append("=?");
        buffer.append(" WHERE ").append("DT_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_VERSION", String.valueOf(this.version)), new SQLParameter("DT_ID", String.valueOf(this.id))};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.version);
            stmt.setLong(2, this.id);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

