/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.transaction;

import java.util.Collection;
import java.util.HashMap;
import javax.transaction.xa.XAException;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.transaction.TransactionBranch;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class TransactionContext {
    private boolean rollbackOnly;
    private boolean prepared;
    private JMSXid xid;
    private HashMap branches;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public TransactionContext() {
    }

    public TransactionContext(JMSXid xid, boolean prepared) {
        this.xid = xid;
        this.branches = new HashMap(3);
        this.prepared = prepared;
    }

    TransactionContext(JMSXid xid) {
        this(xid, false);
    }

    TransactionBranch start(JMSXid xid, int flag, long timeout) throws XAException {
        TransactionBranch branch;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7101_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7101_LEVEL, JeusMessage_JMS5._7101);
        }
        if ((branch = this.peekBranchContext(xid)) == null) {
            if (flag == 0) {
                branch = this.createTransactionBranch(xid);
            } else {
                throw new XAException(-4);
            }
        }
        branch.start(flag, timeout);
        return branch;
    }

    void end(JMSXid xid, int flag, long timeout) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7102_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7102_LEVEL, JeusMessage_JMS5._7102, xid.toString());
        }
        TransactionBranch branch = this.getBranchContext(xid);
        branch.end(flag, timeout);
    }

    int prepare(JMSXid xid, long timeout) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7103_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7103_LEVEL, JeusMessage_JMS5._7103, xid.toString());
        }
        this.checkRollbackOnly();
        TransactionBranch branch = this.getBranchContext(xid);
        int result = branch.prepare(branch.getTransactionID(), timeout);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7104_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7104_LEVEL, JeusMessage_JMS5._7104, new Integer(result));
        }
        if (result == 3) {
            branch.clearWorks();
            this.removeBranchContext(xid);
        }
        this.prepared = result == 0;
        return result;
    }

    void commit(JMSXid xid, boolean onePhase, long timeout) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7105_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7105_LEVEL, JeusMessage_JMS5._7105, new Object[]{onePhase, xid});
        }
        if (this.rollbackOnly) {
            this.rolllback(xid);
            throw new XAException(100);
        }
        TransactionBranch branch = this.getBranchContext(xid);
        branch.commit(branch.getTransactionID(), onePhase, timeout);
        this.removeBranchContext(xid);
    }

    TransactionBranch rolllback(JMSXid xid) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7106_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7106_LEVEL, JeusMessage_JMS5._7106, xid.toString());
        }
        TransactionBranch branch = this.getBranchContext(xid);
        branch.rollback(branch.getTransactionID());
        return this.removeBranchContext(xid);
    }

    void forget(JMSXid xid) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7107_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7107_LEVEL, JeusMessage_JMS5._7107, xid.toString());
        }
        TransactionBranch branch = this.getBranchContext(xid);
        branch.forget(branch.getTransactionID());
        this.removeBranchContext(xid);
    }

    private TransactionBranch createTransactionBranch(JMSXid xid) throws XAException {
        try {
            TransactionBranch branch = new TransactionBranch(this, xid);
            this.addBranchContext(xid, branch);
            return branch;
        }
        catch (Exception e) {
            this.removeBranchContext(xid);
            throw new XAException(-3);
        }
    }

    synchronized TransactionBranch peekBranchContext(JMSXid xid) {
        return (TransactionBranch)this.branches.get(xid);
    }

    synchronized TransactionBranch getBranchContext(JMSXid xid) throws XAException {
        TransactionBranch branch = (TransactionBranch)this.branches.get(xid);
        if (branch == null) {
            throw new XAException(-4);
        }
        return branch;
    }

    synchronized TransactionBranch removeBranchContext(JMSXid xid) {
        return (TransactionBranch)this.branches.remove(xid);
    }

    synchronized void addBranchContext(JMSXid xid, TransactionBranch branch) {
        this.branches.put(xid, branch);
    }

    synchronized void shutdown() {
        for (TransactionBranch branch : this.branches.values()) {
            try {
                branch.rollback(branch.getTransactionID());
            }
            catch (XAException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._7108_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS5._7108_LEVEL, JeusMessage_JMS5._7108, branch.getTransactionID(), (Throwable)e);
            }
        }
        this.branches.clear();
    }

    synchronized boolean isPrepared() {
        return this.prepared;
    }

    synchronized Collection getTransactionBranches() {
        return this.branches.values();
    }

    synchronized void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    synchronized void checkRollbackOnly() throws XAException {
        if (this.rollbackOnly) {
            throw new XAException(-6);
        }
    }

    boolean isParticipant() {
        return !this.isEmpty();
    }

    synchronized boolean isEmpty() {
        return this.branches.isEmpty();
    }

    public String toString() {
        return "xid: " + this.xid + ", " + super.toString();
    }
}

