/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.util;

import java.security.Permission;
import javax.jms.JMSSecurityException;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.util.JeusBootstrapProperties;

public class LoginManager {
    public static Object createSubject(String userName, String password) throws JMSSecurityException {
        if (!JeusBootstrapProperties.isUpperJDK4()) {
            return null;
        }
        try {
            return userName == null ? Subject.makeAnonymousSubject() : Subject.makeSubject((String)userName, (String)password);
        }
        catch (Exception e) {
            JMSSecurityException secEx = new JMSSecurityException(e.getMessage());
            secEx.setLinkedException(e);
            throw secEx;
        }
    }

    public static void authorize(Object subject, Permission permission) throws JMSSecurityException {
        if (!JeusBootstrapProperties.isUpperJDK4()) {
            return;
        }
        try {
            LoginService.login((Subject)((Subject)subject));
            LoginService.checkPermission((Permission)permission);
        }
        catch (Exception e) {
            JMSSecurityException secEx = new JMSSecurityException(e.getMessage());
            secEx.setLinkedException(e);
            throw secEx;
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Exception e) {}
        }
    }
}

