/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import java.net.URL;
import java.net.URLClassLoader;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import jeus.jndi.objectfactory.ReferenceRefAddr;
import jeus.util.JeusRootClassLoader;

public abstract class ConnectionFactoryWrapper
implements Referenceable {
    protected Reference ref = null;
    protected boolean isLocalTransaction;
    protected String exportName;
    protected int resourceType;
    protected String vendor;

    public ConnectionFactoryWrapper(Reference ref, String exportName, boolean isLocalTransaction, int resourceType, String vendor) {
        this.ref = ref;
        this.exportName = exportName;
        this.isLocalTransaction = isLocalTransaction;
        this.resourceType = resourceType;
        this.vendor = vendor;
    }

    public static Object getFactoryFromReference(Reference ref, String exportName) throws JMSException {
        Reference innerRef = (Reference)ref.get(0).getContent();
        String classurl = innerRef.getFactoryClassLocation();
        String classname = innerRef.getFactoryClassName();
        try {
            Class<?> factorycl;
            if (classurl == null) {
                factorycl = JeusRootClassLoader.loader.loadClass(classname);
            } else {
                URL[] srcURL = new URL[]{new URL(innerRef.getFactoryClassLocation())};
                factorycl = new URLClassLoader(srcURL).loadClass(classname);
            }
            ObjectFactory factory = (ObjectFactory)factorycl.newInstance();
            return factory.getObjectInstance(innerRef, null, null, null);
        }
        catch (Throwable t) {
            throw new JMSException(t.getMessage());
        }
    }

    public Reference getReference() throws NamingException {
        if (this.ref == null) {
            this.ref = new Reference("jeus.jms.wrapper.ConnectionFactoryWrapper", "jeus.jms.wrapper.ForeignJMSConnectionFactoryOF", null);
            this.ref.add(0, (RefAddr)new ReferenceRefAddr("CONFACTORY", ((Referenceable)this.getDelegate()).getReference()));
            this.ref.add(1, new StringRefAddr("EXPORTNAME", this.exportName));
            this.ref.add(2, new StringRefAddr("TYPE", Integer.toString(this.resourceType)));
            this.ref.add(3, new StringRefAddr("VENDOR", this.vendor));
        }
        return this.ref;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    public abstract Object getDelegate();
}

