/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import jeus.jms.wrapper.JMSTransactionHandler;

public class QueueSenderWrapper
implements QueueSender {
    private QueueSender Qsender;
    private JMSTransactionHandler handler;

    public QueueSenderWrapper(QueueSender Qsender, JMSTransactionHandler handler) {
        this.Qsender = Qsender;
        this.handler = handler;
    }

    public Queue getQueue() throws JMSException {
        return this.Qsender.getQueue();
    }

    public Destination getDestination() throws JMSException {
        return this.Qsender.getDestination();
    }

    public void send(Message message) throws JMSException {
        this.handler.enlistXAResource();
        this.Qsender.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.handler.enlistXAResource();
        this.Qsender.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.handler.enlistXAResource();
        this.Qsender.send(queue, message);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.handler.enlistXAResource();
        this.Qsender.send(queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination queue, Message message) throws JMSException {
        this.handler.enlistXAResource();
        this.Qsender.send(queue, message);
    }

    public void send(Destination queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.handler.enlistXAResource();
        this.Qsender.send(queue, message, deliveryMode, priority, timeToLive);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.Qsender.setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.Qsender.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.Qsender.setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.Qsender.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.Qsender.setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.Qsender.getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.Qsender.setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.Qsender.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.Qsender.setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.Qsender.getTimeToLive();
    }

    public void close() throws JMSException {
        this.Qsender.close();
    }
}

