/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import jeus.jms.client.external.TransactionProvider;
import jeus.jms.wrapper.JMSTransactionHandler;
import jeus.jms.wrapper.QueueReceiverWrapper;
import jeus.jms.wrapper.QueueSenderWrapper;
import jeus.jms.wrapper.SessionWrapper;

public class QueueSessionWrapper
extends JMSTransactionHandler
implements QueueSession,
SessionWrapper {
    private QueueSession session;
    private String vendor;

    public QueueSessionWrapper(QueueSession Qses, boolean isLocalTransaction, String vendor) {
        super((Session)Qses, isLocalTransaction);
        this.session = Qses;
        this.vendor = vendor;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.session.getAcknowledgeMode();
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.session.createQueue(queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return new QueueReceiverWrapper(this.session.createReceiver(queue), this);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return new QueueReceiverWrapper(this.session.createReceiver(queue, messageSelector), this);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return new QueueReceiverWrapper(this.session.createReceiver((Queue)destination), this);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return new QueueReceiverWrapper(this.session.createReceiver((Queue)destination, messageSelector), this);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return new QueueReceiverWrapper(this.session.createReceiver((Queue)destination, messageSelector), this);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.session.createProducer(destination);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return new QueueSenderWrapper(this.session.createSender(queue), this);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.session.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.session.createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.session.createTemporaryQueue();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.session.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.session.createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        return this.session.getTransacted();
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public void close() throws JMSException {
        this.session.close();
    }

    public void recover() throws JMSException {
        this.session.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.session.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.session.setMessageListener(listener);
    }

    public void run() {
        if (this.vendor.equalsIgnoreCase("ibmmq")) {
            try {
                TransactionProvider.beginUnsharedTransaction();
                this.enlistXAResource();
            }
            catch (Exception jmse) {
                throw new RuntimeException(jmse.toString());
            }
        }
        this.session.run();
    }

    public Session getDelegate() {
        return this.session;
    }

    public Topic createTopic(String topicName) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public void unsubscribe(String name) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }
}

