/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import jeus.jms.wrapper.JMSTransactionHandler;

public class TopicPublisherWrapper
implements TopicPublisher {
    private TopicPublisher Tpub;
    private JMSTransactionHandler handler;

    public TopicPublisherWrapper(TopicPublisher Tpub, JMSTransactionHandler handler) {
        this.Tpub = Tpub;
        this.handler = handler;
    }

    public Destination getDestination() throws JMSException {
        return this.Tpub.getDestination();
    }

    public Topic getTopic() throws JMSException {
        return this.Tpub.getTopic();
    }

    public void publish(Message message) throws JMSException {
        this.handler.enlistXAResource();
        this.Tpub.publish(message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.handler.enlistXAResource();
        this.Tpub.publish(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.handler.enlistXAResource();
        this.Tpub.publish(topic, message);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.handler.enlistXAResource();
        this.Tpub.publish(topic, message, deliveryMode, priority, timeToLive);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.Tpub.setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.Tpub.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.Tpub.setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.Tpub.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.Tpub.setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.Tpub.getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.Tpub.setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.Tpub.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.Tpub.setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.Tpub.getTimeToLive();
    }

    public void close() throws JMSException {
        this.Tpub.close();
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.handler.enlistXAResource();
        this.Tpub.send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.handler.enlistXAResource();
        this.Tpub.send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Message message) throws JMSException {
        this.handler.enlistXAResource();
        this.Tpub.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.handler.enlistXAResource();
        this.Tpub.send(message, deliveryMode, priority, timeToLive);
    }
}

