/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import jeus.jms.wrapper.XAQueueSessionWrapper;

public class XAQueueConnectionWrapper
implements XAQueueConnection {
    private QueueConnection Qcon;
    private boolean isLocalTransaction;
    private String vendor;

    public XAQueueConnectionWrapper(QueueConnection Qcon, boolean isLocalTransaction, String vendor) {
        this.Qcon = Qcon;
        this.isLocalTransaction = isLocalTransaction;
        this.vendor = vendor;
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        if (this.isLocalTransaction) {
            return new XAQueueSessionWrapper((Session)this.Qcon.createQueueSession(true, 1), true, this.vendor);
        }
        return new XAQueueSessionWrapper((Session)((XAQueueConnection)this.Qcon).createXAQueueSession(), false, this.vendor);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createXAQueueSession().getQueueSession();
    }

    public XASession createXASession() throws JMSException {
        if (this.isLocalTransaction) {
            return new XAQueueSessionWrapper((Session)this.Qcon.createQueueSession(true, 1), true, this.vendor);
        }
        return new XAQueueSessionWrapper((Session)((XAQueueConnection)this.Qcon).createXAQueueSession(), false, this.vendor);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createXAQueueSession().getQueueSession();
    }

    public ConnectionConsumer createConnectionConsumer(Destination queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.Qcon.createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.Qcon.createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public String getClientID() throws JMSException {
        return this.Qcon.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.Qcon.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.Qcon.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.Qcon.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.Qcon.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.Qcon.start();
    }

    public void stop() throws JMSException {
        this.Qcon.stop();
    }

    public void close() throws JMSException {
        this.Qcon.close();
    }
}

