/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Reference;
import jeus.jms.wrapper.ConnectionFactoryWrapper;
import jeus.jms.wrapper.XATopicConnectionWrapper;

public class XATopicConnectionFactoryWrapper
extends ConnectionFactoryWrapper
implements XATopicConnectionFactory {
    private TopicConnectionFactory TConfactory;

    public XATopicConnectionFactoryWrapper(TopicConnectionFactory TConfactory, String exportName, boolean isLocalTransaction, int resourceType, String vendor) {
        super(null, exportName, isLocalTransaction, resourceType, vendor);
        this.TConfactory = TConfactory;
    }

    public XATopicConnectionFactoryWrapper(Reference ref, String exportName, boolean isLocalTransaction, int resourceType, String vendor) throws JMSException {
        super(ref, exportName, isLocalTransaction, resourceType, vendor);
        this.TConfactory = (TopicConnectionFactory)XATopicConnectionFactoryWrapper.getFactoryFromReference(ref, exportName);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        if (this.isLocalTransaction) {
            return new XATopicConnectionWrapper(this.TConfactory.createTopicConnection(), true, this.vendor);
        }
        return new XATopicConnectionWrapper((TopicConnection)((XATopicConnectionFactory)this.TConfactory).createXATopicConnection(), false, this.vendor);
    }

    public XAConnection createXAConnection() throws JMSException {
        if (this.isLocalTransaction) {
            return new XATopicConnectionWrapper(this.TConfactory.createTopicConnection(), true, this.vendor);
        }
        return new XATopicConnectionWrapper((TopicConnection)((XATopicConnectionFactory)this.TConfactory).createXATopicConnection(), false, this.vendor);
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        if (this.isLocalTransaction) {
            return new XATopicConnectionWrapper(this.TConfactory.createTopicConnection(userName, password), true, this.vendor);
        }
        return new XATopicConnectionWrapper((TopicConnection)((XATopicConnectionFactory)this.TConfactory).createXATopicConnection(userName, password), false, this.vendor);
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        if (this.isLocalTransaction) {
            return new XATopicConnectionWrapper(this.TConfactory.createTopicConnection(userName, password), true, this.vendor);
        }
        return new XATopicConnectionWrapper((TopicConnection)((XATopicConnectionFactory)this.TConfactory).createXATopicConnection(userName, password), false, this.vendor);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createXATopicConnection();
    }

    public Connection createConnection() throws JMSException {
        return this.createXATopicConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.createXATopicConnection(userName, password);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createXATopicConnection(userName, password);
    }

    public Object getDelegate() {
        return this.TConfactory;
    }
}

