/*
 * Decompiled with CFR 0.152.
 */
package jeus.nio;

import jeus.nio.ByteBufferWrapperFactory;
import jeus.util.ByteArray;

public abstract class ByteBufferWrapper {
    public static ByteBufferWrapper allocate(boolean direct, int capacity) {
        if (direct) {
            return ByteBufferWrapper.allocateDirect(capacity);
        }
        return ByteBufferWrapper.allocate(capacity);
    }

    public static ByteBufferWrapper allocate(int capacity) {
        return ByteBufferWrapperFactory.getFactory().allocate(capacity);
    }

    public static ByteBufferWrapper allocateDirect(int capacity) {
        return ByteBufferWrapperFactory.getFactory().allocateDirect(capacity);
    }

    public static void free(ByteBufferWrapper buffer) {
        ByteBufferWrapperFactory.getFactory().free(buffer);
    }

    public static ByteBufferWrapper wrapDirect(byte[] array) {
        return ByteBufferWrapperFactory.getFactory().wrapDirect(array, 0, array.length);
    }

    public static ByteBufferWrapper wrapDirect(byte[] array, int offset, int length) {
        return ByteBufferWrapperFactory.getFactory().wrapDirect(array, offset, length);
    }

    public static ByteBufferWrapper wrap(byte[] array) {
        return ByteBufferWrapperFactory.getFactory().wrap(array, 0, array.length);
    }

    public static ByteBufferWrapper wrap(byte[] array, int offset, int length) {
        return ByteBufferWrapperFactory.getFactory().wrap(array, offset, length);
    }

    public static ByteBufferWrapper wrap(boolean direct, byte[] array) {
        return ByteBufferWrapper.wrap(direct, array, 0, array.length);
    }

    public static ByteBufferWrapper wrap(boolean direct, byte[] array, int offset, int length) {
        if (direct) {
            return ByteBufferWrapper.wrapDirect(array, offset, length);
        }
        return ByteBufferWrapper.wrap(array, offset, length);
    }

    public ByteBufferWrapper copy() {
        ByteBufferWrapper packet = this.isDirect() ? ByteBufferWrapper.allocateDirect(this.remaining()) : ByteBufferWrapper.allocate(this.remaining());
        packet.put(this);
        packet.flip();
        return packet;
    }

    public ByteArray array() {
        if (this.isDirect() || this.isReadOnly()) {
            byte[] data = new byte[this.remaining()];
            this.get(data).flip();
            return new ByteArray(data);
        }
        return new ByteArray(this._array(), this._arrayOffset(), this.remaining());
    }

    public byte[] compactArray() {
        if (!this.isDirect() && !this.isReadOnly() && this._arrayOffset() == 0 && this.remaining() == this._array().length && this.limit() == this.capacity()) {
            return this._array();
        }
        byte[] data = new byte[this.remaining()];
        this.get(data).flip();
        return data;
    }

    protected abstract byte[] _array();

    protected abstract int _arrayOffset();

    public abstract ByteBufferWrapper asReadOnlyBuffer();

    public abstract ByteBufferWrapper compact();

    public abstract int compareTo(Object var1);

    public abstract ByteBufferWrapper duplicate();

    public abstract boolean equals(Object var1);

    public abstract byte get();

    public abstract ByteBufferWrapper get(byte[] var1);

    public abstract ByteBufferWrapper get(byte[] var1, int var2, int var3);

    public abstract byte get(int var1);

    public abstract char getChar();

    public abstract char getChar(int var1);

    public abstract double getDouble();

    public abstract double getDouble(int var1);

    public abstract float getFloat();

    public abstract float getFloat(int var1);

    public abstract int getInt();

    public abstract int getInt(int var1);

    public abstract long getLong();

    public abstract long getLong(int var1);

    public abstract short getShort();

    public abstract short getShort(int var1);

    public abstract boolean hasArray();

    public abstract boolean isDirect();

    public abstract ByteBufferWrapper put(byte var1);

    public abstract ByteBufferWrapper put(int var1, byte var2);

    public abstract ByteBufferWrapper put(byte[] var1);

    public abstract ByteBufferWrapper put(byte[] var1, int var2, int var3);

    public abstract ByteBufferWrapper put(ByteBufferWrapper var1);

    public abstract ByteBufferWrapper putChar(int var1, char var2);

    public abstract ByteBufferWrapper putChar(char var1);

    public abstract ByteBufferWrapper putDouble(int var1, double var2);

    public abstract ByteBufferWrapper putDouble(double var1);

    public abstract ByteBufferWrapper putFloat(int var1, float var2);

    public abstract ByteBufferWrapper putFloat(float var1);

    public abstract ByteBufferWrapper putInt(int var1, int var2);

    public abstract ByteBufferWrapper putInt(int var1);

    public abstract ByteBufferWrapper putLong(int var1, long var2);

    public abstract ByteBufferWrapper putLong(long var1);

    public abstract ByteBufferWrapper putShort(int var1, short var2);

    public abstract ByteBufferWrapper putShort(short var1);

    public abstract ByteBufferWrapper slice();

    public abstract int capacity();

    public abstract ByteBufferWrapper clear();

    public abstract ByteBufferWrapper flip();

    public abstract boolean hasRemaining();

    public abstract boolean isReadOnly();

    public abstract int limit();

    public abstract ByteBufferWrapper limit(int var1);

    public abstract ByteBufferWrapper mark();

    public abstract int position();

    public abstract ByteBufferWrapper position(int var1);

    public abstract int remaining();

    public abstract ByteBufferWrapper reset();

    public abstract ByteBufferWrapper rewind();

    public abstract Object getSource();
}

