/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.crypto;

import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.SecretKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class KeyGenerator {
    private int algCode = 0;
    private String algName = "";
    private byte[] keyBuff = null;
    private byte[] ivBuff = null;
    private String errBuff = "";
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    protected KeyGenerator() {
    }

    public static final KeyGenerator getInstance(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        KeyGenerator keyGenerator = new KeyGenerator();
        keyGenerator.algCode = Algorithm.getSecretKeyAlg(string);
        if (keyGenerator.algCode == 0) {
            throw new GpkiApiException("Unknown algorithm. (input :" + string + ")");
        }
        keyGenerator.algName = string;
        return keyGenerator;
    }

    public final SecretKey generateKey() throws GpkiApiException {
        if (this.gpkiapi.CRYPT_GenKeyAndIV(Algorithm.code2id(this.algCode)) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        SecretKey secretKey = new SecretKey(this.algName, this.gpkiapi.baKey, this.gpkiapi.baIV);
        return secretKey;
    }
}

