/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.crypto;

import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class MessageDigest {
    private int algCode = 0;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    protected MessageDigest() {
    }

    public static final MessageDigest getInstance(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        MessageDigest messageDigest = new MessageDigest();
        messageDigest.algCode = Algorithm.getHashAlg(string);
        if (messageDigest.algCode == 0) {
            throw new GpkiApiException("Unknown algorithm. (input :" + string + ")");
        }
        return messageDigest;
    }

    public final byte[] digest(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The input is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CRYPT_Hash(Algorithm.code2id(this.algCode), byArray) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }
}

