/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.encoded;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.encoded.ArrayTypeInfo;
import org.apache.cxf.aegis.type.encoded.MarshalRegistry;
import org.apache.cxf.aegis.type.encoded.SoapEncodingUtil;
import org.apache.cxf.aegis.type.encoded.SoapRef;
import org.apache.cxf.aegis.type.encoded.SoapRefType;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.helpers.CastUtils;
import org.apache.ws.commons.schema.XmlSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapArrayType
extends Type {
    private static final Log LOG = LogFactory.getLog(SoapArrayType.class);
    private static final String SOAP_ENCODING_NS_1_1 = Soap11.getInstance().getSoapEncodingStyle();
    private static final QName SOAP_ARRAY_POSITION = new QName(SOAP_ENCODING_NS_1_1, "position");
    private QName componentName;

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        try {
            TypeMapping tm = context.getTypeMapping();
            if (tm == null) {
                tm = this.getTypeMapping();
            }
            ArrayTypeInfo arrayTypeInfo = new ArrayTypeInfo(reader, tm);
            if (this.getDimensions() != arrayTypeInfo.getTotalDimensions()) {
                throw new DatabindingException("In " + this.getSchemaType() + " expected array with " + this.getDimensions() + " dimensions, but arrayType has " + arrayTypeInfo.getTotalDimensions() + " dimensions: " + arrayTypeInfo.toString());
            }
            int maxSize = 1;
            for (int dimension : arrayTypeInfo.getDimensions()) {
                maxSize *= dimension;
            }
            if (arrayTypeInfo.getOffset() >= maxSize) {
                throw new DatabindingException("The array offset " + arrayTypeInfo.getOffset() + " in " + this.getSchemaType() + " exceeds the expecte size of " + maxSize);
            }
            List<Object> values = this.readCollection(reader, context, arrayTypeInfo, maxSize - arrayTypeInfo.getOffset());
            if (arrayTypeInfo.getOffset() > 0) {
                ArrayList<Object> list = new ArrayList<Object>(values.size() + arrayTypeInfo.getOffset());
                list.addAll(Collections.nCopies(arrayTypeInfo.getOffset(), null));
                list.addAll(values);
                values = list;
            }
            if (values.size() > maxSize) {
                throw new DatabindingException("The number of elements " + values.size() + " in " + this.getSchemaType() + " exceeds the expecte size of " + maxSize);
            }
            if (values.size() < maxSize) {
                values.addAll(Collections.nCopies(maxSize - values.size(), null));
            }
            if (values.size() != maxSize) {
                throw new IllegalStateException("Internal error: Expected values collection to contain " + maxSize + " elements but it contains " + values.size() + " elements");
            }
            return this.makeArray(values, arrayTypeInfo.getDimensions(), this.getTypeClass().getComponentType());
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", (Throwable)e);
        }
    }

    protected List<Object> readCollection(MessageReader reader, Context context, ArrayTypeInfo arrayTypeInfo, int maxSize) throws DatabindingException {
        ArrayList<Object> values = new ArrayList<Object>();
        Boolean sparse = null;
        while (reader.hasMoreElementReaders()) {
            Object oldValue;
            Object value;
            Type compType;
            MessageReader creader = reader.getNextElementReader();
            String position = SoapEncodingUtil.readAttributeValue(creader, SOAP_ARRAY_POSITION);
            if (sparse == null) {
                sparse = position != null;
            }
            if ((compType = this.getTypeMapping().getType(creader.getName())) == null) {
                compType = arrayTypeInfo.getType();
            }
            compType = TypeUtil.getReadType(creader.getXMLStreamReader(), context.getGlobalContext(), compType);
            compType = new SoapRefType(compType);
            if (creader.isXsiNil()) {
                value = null;
                creader.readToEnd();
            } else {
                value = compType.readObject(creader, context);
            }
            if (!sparse.booleanValue()) {
                if (values.size() + 1 > maxSize) {
                    throw new DatabindingException("The number of elements in " + this.getSchemaType() + " exceeds the maximum size of " + maxSize);
                }
                values.add(value);
                continue;
            }
            int valuesPosition = this.readValuesPosition(position, arrayTypeInfo.getDimensions());
            if (valuesPosition > maxSize) {
                throw new DatabindingException("Array position " + valuesPosition + " in " + this.getSchemaType() + " exceeds the maximum size of " + maxSize);
            }
            if (values.size() <= valuesPosition) {
                values.addAll(Collections.nCopies(valuesPosition - values.size() + 1, null));
            }
            if ((oldValue = values.set(valuesPosition, value)) == null) continue;
            throw new DatabindingException("Array position " + valuesPosition + " in " + this.getSchemaType() + " is already assigned to value " + oldValue);
        }
        return values;
    }

    private int readValuesPosition(String positionString, List<Integer> dimensions) {
        if (positionString == null) {
            throw new DatabindingException("Sparse array entry does not contain a position attribute");
        }
        try {
            List tokens = CastUtils.cast(Collections.list(new StringTokenizer(positionString, "[],", true)));
            if (tokens.size() == 2 + dimensions.size() + dimensions.size() - 1 && ((String)tokens.get(0)).equals("[") && ((String)tokens.get(tokens.size() - 1)).equals("]")) {
                tokens = tokens.subList(1, tokens.size() - 1);
                int[] index = new int[dimensions.size()];
                for (int i = 0; i < index.length; ++i) {
                    int tokenId = i * 2;
                    index[i] = Integer.parseInt((String)tokens.get(tokenId));
                    if (tokenId + 1 >= tokens.size() || ((String)tokens.get(tokenId + 1)).equals(",")) continue;
                    throw new IllegalStateException("Expected a comma but got " + (String)tokens.get(tokenId + 1));
                }
                int valuePosition = 0;
                int multiplier = 1;
                for (int i = index.length - 1; i >= 0; --i) {
                    int position = index[i];
                    valuePosition += position * multiplier;
                    multiplier *= dimensions.get(i).intValue();
                }
                return valuePosition;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        StringBuilder expectedFormat = new StringBuilder();
        expectedFormat.append("[x");
        for (int i = 1; i < dimensions.size(); ++i) {
            expectedFormat.append(",x");
        }
        expectedFormat.append("]");
        throw new DatabindingException("Expected sparse array position value in format " + expectedFormat + ", but was " + positionString);
    }

    protected Object makeArray(List values, List<Integer> dimensions, Class componentType) {
        if (componentType.isArray() && dimensions.size() > 1) {
            int chunkSize = 1;
            for (Integer dimension : dimensions.subList(1, dimensions.size())) {
                chunkSize *= dimension.intValue();
            }
            Object[] array = (Object[])Array.newInstance(componentType, (int)dimensions.get(0));
            for (int i = 0; i < array.length; ++i) {
                List chunk = values.subList(i * chunkSize, (i + 1) * chunkSize);
                Object value = this.makeArray(chunk, dimensions.subList(1, dimensions.size()), componentType.getComponentType());
                Array.set(array, i, value);
            }
            return array;
        }
        Object array = Array.newInstance(componentType, (int)dimensions.get(0));
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            SoapRef soapRef = (SoapRef)value;
            soapRef.setAction(new SetArrayAction(array, i));
        }
        return array;
    }

    @Override
    public void writeObject(Object values, MessageWriter writer, Context context) throws DatabindingException {
        if (values == null) {
            return;
        }
        Type type = this.getComponentType();
        if (type == null) {
            throw new DatabindingException("Couldn't find component type for array.");
        }
        QName rootType = this.getRootType();
        String prefix = writer.getPrefixForNamespace(rootType.getNamespaceURI(), rootType.getPrefix());
        if (prefix == null) {
            prefix = "";
        }
        rootType = new QName(rootType.getNamespaceURI(), rootType.getLocalPart(), prefix);
        ArrayTypeInfo arrayTypeInfo = new ArrayTypeInfo(rootType, this.getDimensions() - 1, Array.getLength(values));
        writer.getPrefixForNamespace(arrayTypeInfo.getTypeName().getNamespaceURI(), arrayTypeInfo.getTypeName().getPrefix());
        arrayTypeInfo.writeAttribute(writer);
        for (int i = 0; i < Array.getLength(values); ++i) {
            this.writeValue(Array.get(values, i), writer, context, type);
        }
    }

    protected void writeValue(Object value, MessageWriter writer, Context context, Type type) throws DatabindingException {
        type = TypeUtil.getWriteType(context.getGlobalContext(), value, type);
        MessageWriter cwriter = writer.getElementWriter(type.getSchemaType().getLocalPart(), "");
        if (value == null && type.isNillable()) {
            cwriter.writeXsiNil();
        } else if (type instanceof BeanType || type instanceof SoapArrayType) {
            String refId = MarshalRegistry.get(context).getInstanceId(value);
            SoapEncodingUtil.writeRef(cwriter, refId);
        } else {
            type.writeObject(value, cwriter, context);
        }
        cwriter.close();
    }

    @Override
    public void writeSchema(XmlSchema root) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    public QName getComponentName() {
        return this.componentName;
    }

    public void setComponentName(QName componentName) {
        this.componentName = componentName;
    }

    @Override
    public Set<Type> getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getComponentType());
        return deps;
    }

    public Type getComponentType() {
        Type type;
        Class<?> compType = this.getTypeClass().getComponentType();
        if (this.componentName == null) {
            type = this.getTypeMapping().getType(compType);
        } else {
            type = this.getTypeMapping().getType(this.componentName);
            if (type == null) {
                LOG.debug((Object)("Couldn't find array component type " + this.componentName + ". Creating one instead."));
            }
        }
        if (type == null) {
            type = this.getTypeMapping().getTypeCreator().createType(compType);
            this.getTypeMapping().register(type);
        }
        return type;
    }

    protected QName getRootType() {
        Type componentType = this.getComponentType();
        if (componentType instanceof SoapArrayType) {
            SoapArrayType arrayType = (SoapArrayType)componentType;
            return arrayType.getRootType();
        }
        return componentType.getSchemaType();
    }

    private int getDimensions() {
        int dimensions = 0;
        Class<?> type = this.getTypeClass();
        while (type.isArray()) {
            ++dimensions;
            type = type.getComponentType();
        }
        return dimensions;
    }

    private static class SetArrayAction
    implements SoapRef.Action {
        private final Object array;
        private final int index;

        public SetArrayAction(Object array, int index) {
            this.array = array;
            this.index = index;
        }

        public void onSet(SoapRef ref) {
            Array.set(this.array, this.index, ref.get());
        }
    }
}

