/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.version;

import java.net.URI;
import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.version.AbstractAddressingVersion;
import org.springframework.xml.namespace.QNameUtils;

public class Addressing200408
extends AbstractAddressingVersion {
    private static final String NAMESPACE_URI = "http://schemas.xmlsoap.org/ws/2004/08/addressing";

    public void addAddressingHeaders(SoapMessage message, MessageAddressingProperties map) {
        Assert.notNull((Object)map.getAction(), (String)"'Action' must not be null");
        Assert.notNull((Object)map.getTo(), (String)"'Action' must not be null");
        super.addAddressingHeaders(message, map);
    }

    protected final URI getAnonymous() {
        return URI.create("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous");
    }

    protected final String getInvalidAddressingHeaderFaultReason() {
        return "A message information header is not valid and the message cannot be processed.";
    }

    protected final QName getInvalidAddressingHeaderFaultSubcode() {
        return QNameUtils.createQName((String)NAMESPACE_URI, (String)"InvalidMessageInformationHeader", (String)this.getNamespacePrefix());
    }

    protected final String getMessageAddressingHeaderRequiredFaultReason() {
        return "A required message information header, To, MessageID, or Action, is not present.";
    }

    protected final QName getMessageAddressingHeaderRequiredFaultSubcode() {
        return QNameUtils.createQName((String)NAMESPACE_URI, (String)"MessageInformationHeaderRequired", (String)this.getNamespacePrefix());
    }

    protected final String getNamespaceUri() {
        return NAMESPACE_URI;
    }

    protected final EndpointReference getDefaultReplyTo(EndpointReference from) {
        return from;
    }

    protected final URI getNone() {
        return null;
    }

    public String toString() {
        return "Ws-Addressing August 2004";
    }
}

