/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.provider;

import java.util.Iterator;
import java.util.Properties;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.ws.wsdl.wsdl11.provider.DefaultConcretePartProvider;

public class Soap12Provider
extends DefaultConcretePartProvider {
    public static final String DEFAULT_TRANSPORT_URI = "http://schemas.xmlsoap.org/soap/http";
    public static final String SOAP_12_NAMESPACE_PREFIX = "soap12";
    public static final String SOAP_12_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private String transportUri = "http://schemas.xmlsoap.org/soap/http";
    private Properties soapActions = new Properties();
    private String locationUri;

    public Soap12Provider() {
        this.setBindingSuffix("Soap12");
    }

    public Properties getSoapActions() {
        return this.soapActions;
    }

    public void setSoapActions(Properties soapActions) {
        Assert.notNull((Object)soapActions, (String)"'soapActions' must not be null");
        this.soapActions = soapActions;
    }

    public String getTransportUri() {
        return this.transportUri;
    }

    public void setTransportUri(String transportUri) {
        Assert.notNull((Object)transportUri, (String)"'transportUri' must not be null");
        this.transportUri = transportUri;
    }

    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    protected void populateBinding(Definition definition, Binding binding) throws WSDLException {
        definition.addNamespace(SOAP_12_NAMESPACE_PREFIX, SOAP_12_NAMESPACE_URI);
        super.populateBinding(definition, binding);
        SOAP12Binding soapBinding = (SOAP12Binding)this.createSoapExtension(definition, Binding.class, "binding");
        this.populateSoapBinding(soapBinding, binding);
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
    }

    protected void populateSoapBinding(SOAP12Binding soapBinding, Binding binding) throws WSDLException {
        soapBinding.setStyle("document");
        soapBinding.setTransportURI(this.getTransportUri());
    }

    protected void populateBindingFault(Definition definition, BindingFault bindingFault, Fault fault) throws WSDLException {
        super.populateBindingFault(definition, bindingFault, fault);
        SOAP12Fault soapFault = (SOAP12Fault)this.createSoapExtension(definition, BindingFault.class, "fault");
        this.populateSoapFault(bindingFault, soapFault);
        bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
    }

    protected void populateSoapFault(BindingFault bindingFault, SOAP12Fault soapFault) throws WSDLException {
        soapFault.setName(bindingFault.getName());
        soapFault.setUse("literal");
    }

    protected void populateBindingInput(Definition definition, BindingInput bindingInput, Input input) throws WSDLException {
        super.populateBindingInput(definition, bindingInput, input);
        SOAP12Body soapBody = (SOAP12Body)this.createSoapExtension(definition, BindingInput.class, "body");
        this.populateSoapBody(soapBody);
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
    }

    protected void populateSoapBody(SOAP12Body soapBody) throws WSDLException {
        soapBody.setUse("literal");
    }

    protected void populateBindingOperation(Definition definition, BindingOperation bindingOperation) throws WSDLException {
        super.populateBindingOperation(definition, bindingOperation);
        SOAP12Operation soapOperation = (SOAP12Operation)this.createSoapExtension(definition, BindingOperation.class, "operation");
        this.populateSoapOperation(soapOperation, bindingOperation);
        bindingOperation.addExtensibilityElement((ExtensibilityElement)soapOperation);
    }

    protected void populateSoapOperation(SOAP12Operation soapOperation, BindingOperation bindingOperation) throws WSDLException {
        String bindingOperationName = bindingOperation.getName();
        String soapAction = this.getSoapActions().getProperty(bindingOperationName, "");
        soapOperation.setSoapActionURI(soapAction);
    }

    protected void populateBindingOutput(Definition definition, BindingOutput bindingOutput, Output output) throws WSDLException {
        super.populateBindingOutput(definition, bindingOutput, output);
        SOAP12Body soapBody = (SOAP12Body)this.createSoapExtension(definition, BindingOutput.class, "body");
        this.populateSoapBody(soapBody);
        bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
    }

    protected void populatePort(Definition definition, Port port) throws WSDLException {
        Iterator iterator = port.getBinding().getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof SOAP12Binding)) continue;
            super.populatePort(definition, port);
            SOAP12Address soapAddress = (SOAP12Address)this.createSoapExtension(definition, Port.class, "address");
            this.populateSoapAddress(soapAddress);
            port.addExtensibilityElement((ExtensibilityElement)soapAddress);
            return;
        }
    }

    protected void populateSoapAddress(SOAP12Address soapAddress) throws WSDLException {
        soapAddress.setLocationURI(this.getLocationUri());
    }

    private ExtensibilityElement createSoapExtension(Definition definition, Class parentType, String localName) throws WSDLException {
        return definition.getExtensionRegistry().createExtension(parentType, new QName(SOAP_12_NAMESPACE_URI, localName));
    }
}

