/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.compress.AbstractArchive;
import org.apache.commons.compress.ArchiveEntry;
import org.apache.commons.compress.ArchiveException;
import org.apache.commons.compress.UnpackException;
import org.apache.commons.compress.archivers.tar.TarEntry;
import org.apache.commons.compress.archivers.tar.TarInputStream;
import org.apache.commons.compress.archivers.tar.TarOutputStream;

public class TarArchive
extends AbstractArchive {
    private static final int BUFFER = 2048;
    public static final String DEFAULT_FILE_EXTENSION = "tar";
    private static final String ARCHIVER_NAME = "tar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnpack(File unpackDir) throws UnpackException {
        FileInputStream fInputStream = null;
        TarInputStream zInputStream = null;
        try {
            fInputStream = new FileInputStream(this.getArchive());
            zInputStream = new TarInputStream(new BufferedInputStream(fInputStream));
        }
        catch (FileNotFoundException e) {
            throw new UnpackException("SourceFile could not be found.", e);
        }
        try {
            TarEntry entry = null;
            while ((entry = zInputStream.getNextEntry()) != null) {
                BufferedOutputStream destination = null;
                byte[] data = new byte[2048];
                String filename = "";
                File f = new File(entry.getName());
                filename = f.isAbsolute() ? entry.getName().substring(3) : entry.getName();
                String fosString = unpackDir.getPath() + File.separator + filename;
                File destFile = new File(fosString);
                File destPath = new File(destFile.getParent());
                destPath.mkdirs();
                FileOutputStream fos = new FileOutputStream(destFile);
                try {
                    int count;
                    destination = new BufferedOutputStream(fos, 2048);
                    while ((count = zInputStream.read(data, 0, 2048)) != -1) {
                        destination.write(data, 0, count);
                    }
                    destination.flush();
                }
                finally {
                    if (destination == null) continue;
                    destination.close();
                }
            }
        }
        catch (IOException e) {
            throw new UnpackException("Exception while unpacking.", e);
        }
        finally {
            try {
                fInputStream.close();
            }
            catch (IOException e1) {
                throw new UnpackException("Exception while unpacking.", e1);
            }
        }
    }

    public void doSave(OutputStream output) throws ArchiveException {
        Iterator iterator = this.getEntryIterator();
        if (!iterator.hasNext()) {
            throw new ArchiveException("There must be at least one file to be pack.");
        }
        TarOutputStream out = null;
        try {
            out = new TarOutputStream(new BufferedOutputStream(output));
            while (iterator.hasNext()) {
                ArchiveEntry archiveEntry = (ArchiveEntry)iterator.next();
                InputStream fInputStream = archiveEntry.getStream();
                TarEntry entry = new TarEntry(archiveEntry.getName());
                entry.setModTime(0L);
                entry.setSize(fInputStream.available());
                entry.setUserID(0);
                entry.setGroupID(0);
                entry.setUserName("avalon");
                entry.setGroupName("excalibur");
                entry.setMode(32768);
                out.putNextEntry(entry);
                out.copyEntryContents(fInputStream);
                out.closeEntry();
            }
        }
        catch (IOException e) {
            throw new ArchiveException("Creation of this archive failed cause of IOExceptions.", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e1) {
                throw new ArchiveException("Creation of this archive failed cause of IOExceptions.", e1);
            }
        }
    }

    public String getName() {
        return "tar";
    }

    public String getDefaultFileExtension() {
        return "tar";
    }

    public byte[] getHeader() {
        return null;
    }
}

