/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractCompressor;
import org.apache.commons.compress.CompressException;
import org.apache.commons.compress.CompressUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2InputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2OutputStream;

public class BZip2Compressor
extends AbstractCompressor {
    private static final byte[] HEADER = new byte[]{66, 90};
    private static final String NAME = "bz2";
    private static String DEFAULT_FILE_EXTENSION = "bz2";

    public void compressTo(InputStream in, OutputStream out) throws CompressException {
        BZip2OutputStream outputBZStream = null;
        try {
            outputBZStream = this.getPackedOutput(out);
            CompressUtils.copy(in, outputBZStream);
        }
        catch (FileNotFoundException e) {
            throw new CompressException("File could not be found", e);
        }
        catch (IOException e) {
            throw new CompressException("An IO Exception occured", e);
        }
        finally {
            try {
                if (outputBZStream != null) {
                    outputBZStream.close();
                }
            }
            catch (IOException e1) {
                throw new CompressException("An IO Exception occured while closing the streams", e1);
            }
        }
    }

    public void decompressTo(InputStream in, OutputStream out) throws CompressException {
        BZip2InputStream inputStream = null;
        try {
            inputStream = this.getPackedInput(in);
            CompressUtils.copy(inputStream, out);
        }
        catch (IOException e) {
            throw new CompressException("An I/O Exception has occured", e);
        }
    }

    private BZip2InputStream getPackedInput(InputStream input) throws IOException {
        input.read();
        input.read();
        return new BZip2InputStream(input);
    }

    private BZip2OutputStream getPackedOutput(OutputStream output) throws IOException {
        output.write(HEADER);
        return new BZip2OutputStream(output);
    }

    public byte[] getHeader() {
        return HEADER;
    }

    public String getName() {
        return NAME;
    }

    public String getDefaultFileExtension() {
        return DEFAULT_FILE_EXTENSION;
    }
}

