/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.rad;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class RadWebsiteConfigWriter
extends AbstractEclipseWriter {
    private static final String WEBSITE_CONFIG_FILENAME = ".website-config";
    private static final String WEBSITE_CONFIG_STRUCTURE = "structure";
    private static final String WEBSITE_CONFIG_VERSION = "version";
    private static final String WEBSITE_CONFIG_WEBSITE = "website";

    public void write() throws MojoExecutionException {
        MavenProject project = this.config.getProject();
        if ("war".equalsIgnoreCase(project.getPackaging())) {
            FileWriter w;
            try {
                w = new FileWriter(new File(this.config.getEclipseProjectDirectory(), WEBSITE_CONFIG_FILENAME));
            }
            catch (IOException ex) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
            }
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
            this.writeModuleTypeFacetCore((XMLWriter)writer);
            IOUtil.close((Writer)w);
        }
    }

    private void writeModuleTypeFacetCore(XMLWriter writer) {
        writer.startElement(WEBSITE_CONFIG_WEBSITE);
        writer.addAttribute(WEBSITE_CONFIG_VERSION, "600");
        writer.startElement(WEBSITE_CONFIG_STRUCTURE);
        writer.endElement();
        writer.endElement();
    }
}

