/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.wtp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.wtp.AbstractWtpResourceWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.ide.JeeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseWtpFacetsWriter
extends AbstractWtpResourceWriter {
    private static final String FACET_JST_EAR = "jst.ear";
    private static final String FACET_JST_UTILITY = "jst.utility";
    private static final String FACET_JST_EJB = "jst.ejb";
    private static final String FACET_JST_WEB = "jst.web";
    private static final String FACET_JST_JAVA = "jst.java";
    private static final String ATTR_VERSION = "version";
    private static final String ELT_INSTALLED = "installed";
    private static final String ATTR_FACET = "facet";
    private static final String ELT_FIXED = "fixed";
    private static final String ELT_FACETED_PROJECT = "faceted-project";
    private static final String DIR_WTP_SETTINGS = ".settings";
    private static final String FILE_FACET_CORE_XML = "org.eclipse.wst.common.project.facet.core.xml";

    public void write() throws MojoExecutionException {
        FileWriter w;
        File settingsDir = new File(this.config.getEclipseProjectDirectory(), DIR_WTP_SETTINGS);
        settingsDir.mkdirs();
        String packaging = this.config.getProject().getPackaging();
        try {
            w = new FileWriter(new File(settingsDir, FILE_FACET_CORE_XML));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        this.writeModuleTypeFacetCore((XMLWriter)writer, packaging);
        IOUtil.close((Writer)w);
    }

    private void writeModuleTypeFacetCore(XMLWriter writer, String packaging) {
        writer.startElement(ELT_FACETED_PROJECT);
        writer.startElement(ELT_FIXED);
        writer.addAttribute(ATTR_FACET, FACET_JST_JAVA);
        writer.endElement();
        if ("war".equalsIgnoreCase(packaging)) {
            writer.startElement(ELT_FIXED);
            writer.addAttribute(ATTR_FACET, FACET_JST_WEB);
            writer.endElement();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, FACET_JST_WEB);
            writer.addAttribute(ATTR_VERSION, JeeUtils.resolveServletVersion(this.config.getProject()));
            writer.endElement();
        } else if ("ejb".equalsIgnoreCase(packaging)) {
            writer.startElement(ELT_FIXED);
            writer.addAttribute(ATTR_FACET, FACET_JST_EJB);
            writer.endElement();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, FACET_JST_EJB);
            writer.addAttribute(ATTR_VERSION, JeeUtils.resolveEjbVersion(this.config.getProject()));
            writer.endElement();
        } else if ("ear".equalsIgnoreCase(packaging)) {
            writer.startElement(ELT_FIXED);
            writer.addAttribute(ATTR_FACET, FACET_JST_EAR);
            writer.endElement();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, FACET_JST_EAR);
            writer.addAttribute(ATTR_VERSION, JeeUtils.resolveJeeVersion(this.config.getProject()));
            writer.endElement();
        } else if ("jar".equalsIgnoreCase(packaging)) {
            writer.startElement(ELT_FIXED);
            writer.addAttribute(ATTR_FACET, FACET_JST_UTILITY);
            writer.endElement();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, FACET_JST_UTILITY);
            writer.addAttribute(ATTR_VERSION, "1.0");
            writer.endElement();
        }
        writer.startElement(ELT_INSTALLED);
        writer.addAttribute(ATTR_FACET, FACET_JST_JAVA);
        writer.addAttribute(ATTR_VERSION, IdeUtils.resolveJavaVersion(this.config.getProject()));
        writer.endElement();
        this.writeAdditionalProjectFacets(writer);
        writer.endElement();
    }

    private void writeAdditionalProjectFacets(XMLWriter writer) {
        if (this.config.getProjectFacets() == null) {
            return;
        }
        Iterator facetIterator = this.config.getProjectFacets().entrySet().iterator();
        while (facetIterator.hasNext()) {
            Map.Entry facetEntry = facetIterator.next();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, (String)facetEntry.getKey());
            writer.addAttribute(ATTR_VERSION, (String)facetEntry.getValue());
            writer.endElement();
        }
    }
}

