/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeUtils;

public class EclipseSettingsWriter
extends AbstractEclipseWriter {
    private static final String JDK_1_2_SOURCES = "1.2";
    private static final String FILE_ECLIPSE_JDT_CORE_PREFS = "org.eclipse.jdt.core.prefs";
    private static final String PROP_ECLIPSE_PREFERENCES_VERSION = "eclipse.preferences.version";
    private static final String DIR_DOT_SETTINGS = ".settings";
    private static final String PROP_JDT_CORE_COMPILER_COMPLIANCE = "org.eclipse.jdt.core.compiler.compliance";
    private static final String PROP_JDT_CORE_COMPILER_SOURCE = "org.eclipse.jdt.core.compiler.source";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write() throws MojoExecutionException {
        Properties coreSettings = new Properties();
        String source = IdeUtils.getCompilerSourceVersion(this.config.getProject());
        String target = IdeUtils.getCompilerTargetVersion(this.config.getProject());
        if (source != null) {
            coreSettings.put(PROP_JDT_CORE_COMPILER_SOURCE, source);
            coreSettings.put(PROP_JDT_CORE_COMPILER_COMPLIANCE, source);
        }
        if (target != null && !JDK_1_2_SOURCES.equals(target)) {
            coreSettings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", target);
        }
        if (!coreSettings.isEmpty()) {
            File settingsDir = new File(this.config.getEclipseProjectDirectory(), DIR_DOT_SETTINGS);
            settingsDir.mkdirs();
            coreSettings.put(PROP_ECLIPSE_PREFERENCES_VERSION, "1");
            try {
                File coreSettingsFile = new File(settingsDir, FILE_ECLIPSE_JDT_CORE_PREFS);
                if (coreSettingsFile.exists()) {
                    File oldCoreSettingsFile = coreSettingsFile;
                    Properties oldsettings = new Properties();
                    oldsettings.load(new FileInputStream(oldCoreSettingsFile));
                    Properties newsettings = (Properties)oldsettings.clone();
                    newsettings.putAll((Map<?, ?>)coreSettings);
                    if (oldsettings.equals(newsettings)) return;
                    newsettings.store(new FileOutputStream(coreSettingsFile), null);
                    return;
                }
                coreSettings.store(new FileOutputStream(coreSettingsFile), null);
                this.log.info((CharSequence)Messages.getString("EclipseSettingsWriter.wrotesettings", coreSettingsFile.getCanonicalPath()));
                return;
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.cannotcreatesettings"), (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.errorwritingsettings"), (Exception)e);
            }
        } else {
            this.log.info((CharSequence)Messages.getString("EclipseSettingsWriter.usingdefaults"));
        }
    }
}

