/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.EjbJar;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;

public class WeblogicDeploymentTool
extends GenericDeploymentTool {
    public static final String PUBLICID_EJB11 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static final String PUBLICID_EJB20 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static final String PUBLICID_WEBLOGIC_EJB510 = "-//BEA Systems, Inc.//DTD WebLogic 5.1.0 EJB//EN";
    public static final String PUBLICID_WEBLOGIC_EJB600 = "-//BEA Systems, Inc.//DTD WebLogic 6.0.0 EJB//EN";
    public static final String PUBLICID_WEBLOGIC_EJB700 = "-//BEA Systems, Inc.//DTD WebLogic 7.0.0 EJB//EN";
    protected static final String DEFAULT_WL51_EJB11_DTD_LOCATION = "/weblogic/ejb/deployment/xml/ejb-jar.dtd";
    protected static final String DEFAULT_WL60_EJB11_DTD_LOCATION = "/weblogic/ejb20/dd/xml/ejb11-jar.dtd";
    protected static final String DEFAULT_WL60_EJB20_DTD_LOCATION = "/weblogic/ejb20/dd/xml/ejb20-jar.dtd";
    protected static final String DEFAULT_WL51_DTD_LOCATION = "/weblogic/ejb/deployment/xml/weblogic-ejb-jar.dtd";
    protected static final String DEFAULT_WL60_51_DTD_LOCATION = "/weblogic/ejb20/dd/xml/weblogic510-ejb-jar.dtd";
    protected static final String DEFAULT_WL60_DTD_LOCATION = "/weblogic/ejb20/dd/xml/weblogic600-ejb-jar.dtd";
    protected static final String DEFAULT_WL70_DTD_LOCATION = "/weblogic/ejb20/dd/xml/weblogic700-ejb-jar.dtd";
    protected static final String DEFAULT_COMPILER = "default";
    protected static final String WL_DD = "weblogic-ejb-jar.xml";
    protected static final String WL_CMP_DD = "weblogic-cmp-rdbms-jar.xml";
    protected static final String COMPILER_EJB11 = "weblogic.ejbc";
    protected static final String COMPILER_EJB20 = "weblogic.ejbc20";
    private String jarSuffix = ".jar";
    private String weblogicDTD;
    private String ejb11DTD;
    private boolean keepgenerated = false;
    private String ejbcClass = null;
    private String additionalArgs = "";
    private String additionalJvmArgs = "";
    private boolean keepGeneric = false;
    private String compiler = null;
    private boolean alwaysRebuild = true;
    private boolean noEJBC = false;
    private boolean newCMP = false;
    private Path wlClasspath = null;
    private Vector sysprops = new Vector();
    private Integer jvmDebugLevel = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private File outputDir;

    public void addSysproperty(Environment.Variable sysp) {
        this.sysprops.add(sysp);
    }

    public Path createWLClasspath() {
        if (this.wlClasspath == null) {
            this.wlClasspath = new Path(this.getTask().getProject());
        }
        return this.wlClasspath.createPath();
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setWLClasspath(Path wlClasspath) {
        this.wlClasspath = wlClasspath;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }

    public void setRebuild(boolean rebuild) {
        this.alwaysRebuild = rebuild;
    }

    public void setJvmDebugLevel(Integer jvmDebugLevel) {
        this.jvmDebugLevel = jvmDebugLevel;
    }

    public Integer getJvmDebugLevel() {
        return this.jvmDebugLevel;
    }

    public void setSuffix(String inString) {
        this.jarSuffix = inString;
    }

    public void setKeepgeneric(boolean inValue) {
        this.keepGeneric = inValue;
    }

    public void setKeepgenerated(String inValue) {
        this.keepgenerated = Boolean.valueOf(inValue);
    }

    public void setArgs(String args) {
        this.additionalArgs = args;
    }

    public void setJvmargs(String args) {
        this.additionalJvmArgs = args;
    }

    public void setEjbcClass(String ejbcClass) {
        this.ejbcClass = ejbcClass;
    }

    public String getEjbcClass() {
        return this.ejbcClass;
    }

    public void setWeblogicdtd(String inString) {
        this.setEJBdtd(inString);
    }

    public void setWLdtd(String inString) {
        this.weblogicDTD = inString;
    }

    public void setEJBdtd(String inString) {
        this.ejb11DTD = inString;
    }

    public void setOldCMP(boolean oldCMP) {
        this.newCMP = !oldCMP;
    }

    public void setNewCMP(boolean newCMP) {
        this.newCMP = newCMP;
    }

    public void setNoEJBC(boolean noEJBC) {
        this.noEJBC = noEJBC;
    }

    protected void registerKnownDTDs(DescriptorHandler handler) {
        handler.registerDTD(PUBLICID_EJB11, DEFAULT_WL51_EJB11_DTD_LOCATION);
        handler.registerDTD(PUBLICID_EJB11, DEFAULT_WL60_EJB11_DTD_LOCATION);
        handler.registerDTD(PUBLICID_EJB11, this.ejb11DTD);
        handler.registerDTD(PUBLICID_EJB20, DEFAULT_WL60_EJB20_DTD_LOCATION);
    }

    protected DescriptorHandler getWeblogicDescriptorHandler(final File srcDir) {
        DescriptorHandler handler = new DescriptorHandler(this.getTask(), srcDir){

            protected void processElement() {
                if (this.currentElement.equals("type-storage")) {
                    String fileNameWithMETA = this.currentText;
                    String fileName = fileNameWithMETA.substring("META-INF/".length(), fileNameWithMETA.length());
                    File descriptorFile = new File(srcDir, fileName);
                    this.ejbFiles.put(fileNameWithMETA, descriptorFile);
                }
            }
        };
        handler.registerDTD(PUBLICID_WEBLOGIC_EJB510, DEFAULT_WL51_DTD_LOCATION);
        handler.registerDTD(PUBLICID_WEBLOGIC_EJB510, DEFAULT_WL60_51_DTD_LOCATION);
        handler.registerDTD(PUBLICID_WEBLOGIC_EJB600, DEFAULT_WL60_DTD_LOCATION);
        handler.registerDTD(PUBLICID_WEBLOGIC_EJB700, DEFAULT_WL70_DTD_LOCATION);
        handler.registerDTD(PUBLICID_WEBLOGIC_EJB510, this.weblogicDTD);
        handler.registerDTD(PUBLICID_WEBLOGIC_EJB600, this.weblogicDTD);
        Iterator i = this.getConfig().dtdLocations.iterator();
        while (i.hasNext()) {
            EjbJar.DTDLocation dtdLocation = (EjbJar.DTDLocation)((Object)i.next());
            handler.registerDTD(dtdLocation.getPublicId(), dtdLocation.getLocation());
        }
        return handler;
    }

    protected void addVendorFiles(Hashtable ejbFiles, String ddPrefix) {
        File weblogicDD = new File(this.getConfig().descriptorDir, ddPrefix + WL_DD);
        if (!weblogicDD.exists()) {
            this.log("Unable to locate weblogic deployment descriptor. It was expected to be in " + weblogicDD.getPath(), 1);
            return;
        }
        ejbFiles.put("META-INF/weblogic-ejb-jar.xml", weblogicDD);
        if (!this.newCMP) {
            this.log("The old method for locating CMP files has been DEPRECATED.", 3);
            this.log("Please adjust your weblogic descriptor and set newCMP=\"true\" to use the new CMP descriptor inclusion mechanism. ", 3);
            File weblogicCMPDD = new File(this.getConfig().descriptorDir, ddPrefix + WL_CMP_DD);
            if (weblogicCMPDD.exists()) {
                ejbFiles.put("META-INF/weblogic-cmp-rdbms-jar.xml", weblogicCMPDD);
            }
        } else {
            try {
                File ejbDescriptor = (File)ejbFiles.get("META-INF/ejb-jar.xml");
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                saxParserFactory.setValidating(true);
                SAXParser saxParser = saxParserFactory.newSAXParser();
                DescriptorHandler handler = this.getWeblogicDescriptorHandler(ejbDescriptor.getParentFile());
                saxParser.parse(new InputSource(new FileInputStream(weblogicDD)), (HandlerBase)handler);
                Hashtable ht = handler.getFiles();
                Enumeration e = ht.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    ejbFiles.put(key, ht.get(key));
                }
            }
            catch (Exception e) {
                String msg = "Exception while adding Vendor specific files: " + e.toString();
                throw new BuildException(msg, (Throwable)e);
            }
        }
    }

    File getVendorOutputJarFile(String baseName) {
        return new File(this.getDestDir(), baseName + this.jarSuffix);
    }

    private void buildWeblogicJar(File sourceJar, File destJar, String publicId) {
        Java javaTask = null;
        if (this.noEJBC) {
            try {
                this.fileUtils.copyFile(sourceJar, destJar);
                if (!this.keepgenerated) {
                    sourceJar.delete();
                }
                return;
            }
            catch (IOException e) {
                throw new BuildException("Unable to write EJB jar", (Throwable)e);
            }
        }
        String ejbcClassName = this.ejbcClass;
        try {
            javaTask = (Java)this.getTask().getProject().createTask("java");
            javaTask.setTaskName("ejbc");
            javaTask.createJvmarg().setLine(this.additionalJvmArgs);
            if (!this.sysprops.isEmpty()) {
                Enumeration en = this.sysprops.elements();
                while (en.hasMoreElements()) {
                    Environment.Variable entry = (Environment.Variable)en.nextElement();
                    javaTask.addSysproperty(entry);
                }
            }
            if (this.getJvmDebugLevel() != null) {
                javaTask.createJvmarg().setLine(" -Dweblogic.StdoutSeverityLevel=" + this.jvmDebugLevel);
            }
            if (ejbcClassName == null) {
                if (PUBLICID_EJB11.equals(publicId)) {
                    ejbcClassName = COMPILER_EJB11;
                } else if (PUBLICID_EJB20.equals(publicId)) {
                    ejbcClassName = COMPILER_EJB20;
                } else {
                    this.log("Unrecognized publicId " + publicId + " - using EJB 1.1 compiler", 1);
                    ejbcClassName = COMPILER_EJB11;
                }
            }
            javaTask.setClassname(ejbcClassName);
            javaTask.createArg().setLine(this.additionalArgs);
            if (this.keepgenerated) {
                javaTask.createArg().setValue("-keepgenerated");
            }
            if (this.compiler == null) {
                String buildCompiler = this.getTask().getProject().getProperty("build.compiler");
                if (buildCompiler != null && buildCompiler.equals("jikes")) {
                    javaTask.createArg().setValue("-compiler");
                    javaTask.createArg().setValue("jikes");
                }
            } else if (!this.compiler.equals(DEFAULT_COMPILER)) {
                javaTask.createArg().setValue("-compiler");
                javaTask.createArg().setLine(this.compiler);
            }
            Path combinedClasspath = this.getCombinedClasspath();
            if (this.wlClasspath != null && combinedClasspath != null && combinedClasspath.toString().trim().length() > 0) {
                javaTask.createArg().setValue("-classpath");
                javaTask.createArg().setPath(combinedClasspath);
            }
            javaTask.createArg().setValue(sourceJar.getPath());
            if (this.outputDir == null) {
                javaTask.createArg().setValue(destJar.getPath());
            } else {
                javaTask.createArg().setValue(this.outputDir.getPath());
            }
            Path classpath = this.wlClasspath;
            if (classpath == null) {
                classpath = this.getCombinedClasspath();
            }
            javaTask.setFork(true);
            if (classpath != null) {
                javaTask.setClasspath(classpath);
            }
            this.log("Calling " + ejbcClassName + " for " + sourceJar.toString(), 3);
            if (javaTask.executeJava() != 0) {
                throw new BuildException("Ejbc reported an error");
            }
        }
        catch (Exception e) {
            String msg = "Exception while calling " + ejbcClassName + ". Details: " + e.toString();
            throw new BuildException(msg, (Throwable)e);
        }
    }

    protected void writeJar(String baseName, File jarFile, Hashtable files, String publicId) throws BuildException {
        File genericJarFile = super.getVendorOutputJarFile(baseName);
        super.writeJar(baseName, genericJarFile, files, publicId);
        if (this.alwaysRebuild || this.isRebuildRequired(genericJarFile, jarFile)) {
            this.buildWeblogicJar(genericJarFile, jarFile, publicId);
        }
        if (!this.keepGeneric) {
            this.log("deleting generic jar " + genericJarFile.toString(), 3);
            genericJarFile.delete();
        }
    }

    public void validateConfigured() throws BuildException {
        super.validateConfigured();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isRebuildRequired(File genericJarFile, File weblogicJarFile) {
        boolean rebuild = false;
        ZipFile genericJar = null;
        ZipFile wlJar = null;
        File newWLJarFile = null;
        ZipOutputStream newJarStream = null;
        try {
            this.log("Checking if weblogic Jar needs to be rebuilt for jar " + weblogicJarFile.getName(), 3);
            if (genericJarFile.exists() && genericJarFile.isFile() && weblogicJarFile.exists() && weblogicJarFile.isFile()) {
                genericJar = new JarFile(genericJarFile);
                wlJar = new JarFile(weblogicJarFile);
                Hashtable<String, JarEntry> genericEntries = new Hashtable<String, JarEntry>();
                Hashtable<String, JarEntry> wlEntries = new Hashtable<String, JarEntry>();
                Hashtable<String, JarEntry> replaceEntries = new Hashtable<String, JarEntry>();
                Enumeration<JarEntry> e = ((JarFile)genericJar).entries();
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    genericEntries.put(je.getName().replace('\\', '/'), je);
                }
                Enumeration<JarEntry> e2 = ((JarFile)wlJar).entries();
                while (e2.hasMoreElements()) {
                    JarEntry je = e2.nextElement();
                    wlEntries.put(je.getName(), je);
                }
                ClassLoader genericLoader = this.getClassLoaderFromJar(genericJarFile);
                Enumeration e3 = genericEntries.keys();
                while (e3.hasMoreElements()) {
                    String filepath = (String)e3.nextElement();
                    if (wlEntries.containsKey(filepath)) {
                        JarEntry genericEntry = (JarEntry)genericEntries.get(filepath);
                        JarEntry wlEntry = (JarEntry)wlEntries.get(filepath);
                        if (genericEntry.getCrc() == wlEntry.getCrc() && genericEntry.getSize() == wlEntry.getSize()) continue;
                        if (genericEntry.getName().endsWith(".class")) {
                            String classname = genericEntry.getName().replace(File.separatorChar, '.');
                            Class<?> genclass = genericLoader.loadClass(classname = classname.substring(0, classname.lastIndexOf(".class")));
                            if (genclass.isInterface()) {
                                this.log("Interface " + genclass.getName() + " has changed", 3);
                                rebuild = true;
                                break;
                            }
                            replaceEntries.put(filepath, genericEntry);
                            continue;
                        }
                        if (genericEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                        this.log("Non class file " + genericEntry.getName() + " has changed", 3);
                        rebuild = true;
                        break;
                    }
                    this.log("File " + filepath + " not present in weblogic jar", 3);
                    rebuild = true;
                    break;
                }
                if (!rebuild) {
                    this.log("No rebuild needed - updating jar", 3);
                    newWLJarFile = new File(weblogicJarFile.getAbsolutePath() + ".temp");
                    if (newWLJarFile.exists()) {
                        newWLJarFile.delete();
                    }
                    newJarStream = new JarOutputStream(new FileOutputStream(newWLJarFile));
                    newJarStream.setLevel(0);
                    Enumeration e4 = wlEntries.elements();
                    while (e4.hasMoreElements()) {
                        int bytesRead;
                        InputStream is;
                        byte[] buffer = new byte[1024];
                        JarEntry je = (JarEntry)e4.nextElement();
                        if (je.getCompressedSize() == -1L || je.getCompressedSize() == je.getSize()) {
                            newJarStream.setLevel(0);
                        } else {
                            newJarStream.setLevel(9);
                        }
                        if (replaceEntries.containsKey(je.getName())) {
                            this.log("Updating Bean class from generic Jar " + je.getName(), 3);
                            je = (JarEntry)replaceEntries.get(je.getName());
                            is = ((JarFile)genericJar).getInputStream(je);
                        } else {
                            is = ((JarFile)wlJar).getInputStream(je);
                        }
                        ((JarOutputStream)newJarStream).putNextEntry(new JarEntry(je.getName()));
                        while ((bytesRead = is.read(buffer)) != -1) {
                            void wlEntry;
                            newJarStream.write(buffer, 0, (int)wlEntry);
                        }
                        is.close();
                    }
                } else {
                    this.log("Weblogic Jar rebuild needed due to changed interface or XML", 3);
                }
                if (genericLoader instanceof AntClassLoader) {
                    AntClassLoader loader = (AntClassLoader)genericLoader;
                    loader.cleanup();
                }
            } else {
                rebuild = true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            String cnfmsg = "ClassNotFoundException while processing ejb-jar file. Details: " + cnfe.getMessage();
            throw new BuildException(cnfmsg, (Throwable)cnfe);
        }
        catch (IOException ioe) {
            String msg = "IOException while processing ejb-jar file . Details: " + ioe.getMessage();
            throw new BuildException(msg, (Throwable)ioe);
        }
        finally {
            if (genericJar != null) {
                try {
                    genericJar.close();
                }
                catch (IOException closeException) {}
            }
            if (wlJar != null) {
                try {
                    wlJar.close();
                }
                catch (IOException closeException) {}
            }
            if (newJarStream != null) {
                try {
                    newJarStream.close();
                }
                catch (IOException closeException) {}
                try {
                    this.fileUtils.rename(newWLJarFile, weblogicJarFile);
                }
                catch (IOException renameException) {
                    this.log(renameException.getMessage(), 1);
                    rebuild = true;
                }
            }
        }
        return rebuild;
    }

    protected ClassLoader getClassLoaderFromJar(File classjar) throws IOException {
        Path lookupPath = new Path(this.getTask().getProject());
        lookupPath.setLocation(classjar);
        Path classpath = this.getCombinedClasspath();
        if (classpath != null) {
            lookupPath.append(classpath);
        }
        return this.getTask().getProject().createClassLoader(lookupPath);
    }
}

