package egovframework.rex.util.web.single.controllers;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import egovframework.rex.util.fileupload.single.service.MultiPartFileUploadBean;

/**
 * @Class Name : MultiPartFileUploadController.java
 * @Description : SingFileUpload MultiPartFile을 TEST하기 위한 class
 * @Modification Information
 * @
 * @  수정일         수정자                   수정내용
 * @ -------    --------    ---------------------------
 * @ 2009.03.05     이동도          최초 생성
 *
 *  @author 실행환경 개발팀 이동도
 *  @since 2009.03.05
 *  @version 1.0
 *  @see
 *  
 *  Copyright (C) 2009 by MOPAS  All right reserved.
 */

@Controller("multiPartFileUploadController")
public class MultiPartFileUploadController {
	
    final static Logger logger = LoggerFactory.getLogger(MultiPartFileUploadController.class);

    @RequestMapping(value = "/upload/multiPartFileSingle.do")
    protected String singlemultipartProcess (HttpServletRequest request, Object command) throws Exception {
        
        /*
         * validate type of request and type of form backing object bean
         */
        Assert.state(request instanceof MultipartHttpServletRequest, "request !instanceof MultipartHttpServletRequest");
        Assert.state(command instanceof MultiPartFileUploadBean, "command !instanceof MultiPartFileUploadBean");
        
        /*
         * validate binding of text input field
         */
        MultiPartFileUploadBean bean = (MultiPartFileUploadBean) command;
        Assert.state(bean.getType().equals("multiPartFileSingle"), "type != multiPartFileSingle");
        
        /*
         * validate binding of uploaded file
         */
        MultipartFile file = bean.getFile();
        Assert.notNull(file, "multi part file must not be null");
        
        return singlemultipartProcess(request, command);
    }
    
}