package egovframework.rex.util.web.mail.controllers;

/**
 * @file Name : MailAttachController.java
 * @Description : MailAttachController
 * @Modification Information
 * @
 * @  수정일         수정자                   수정내용
 * @ -------    --------    ---------------------------
 * @ 2009.03.05      이동도          최초 생성
 *
 *  @author 실행환경 개발팀 이동도
 *  @since 2009.03.05
 *  @version 1.0
 *  @see
 *  
 *  Copyright (C) 2009 by MOPAS  All right reserved.
 */

import java.io.File;
import java.io.FileOutputStream;

import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.MultiPartEmail;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import egovframework.rex.util.fileupload.mail.service.MailVO;

@Controller("mailAttachController")
public class MailAttachController {
	
/*	@Resource(name = "multipartResolver")
	CommonsMultipartResolver multipartResolver;*/

	@RequestMapping(value = "/mail/mailAttach.do")
	public String mailAttachProcess(MailVO mailVO) throws Exception {
		
		//local test용 경로  UNIX에서 TEST시에는 경로 변경
		String savePath = "C:\\temp";
		File saveFolder = new File(savePath);
		
		// 디렉토리 생성
		if (!saveFolder.exists() || saveFolder.isFile()) {
			saveFolder.mkdirs();
		}
		
		// 임시 파일명은 Thread 명으로 일단
		String filePath = "";
		if(!mailVO.getFile().isEmpty()){
			filePath = savePath + "\\" + mailVO.getFile().getOriginalFilename();
			File file = new File(filePath);
			FileOutputStream out = new FileOutputStream(file);
			out.write(mailVO.getFile().getBytes());
		}
		
		
		// 첨부할 attachment 정보를 생성합니다
		EmailAttachment attachment = new EmailAttachment();
		attachment.setPath(filePath);
		attachment.setDisposition(EmailAttachment.ATTACHMENT);
		attachment.setDescription(mailVO.getDescription());
		attachment.setName(mailVO.getFile().getOriginalFilename());

		// 기본 메일 정보를 생성합니다 (SMTP서버의 기본정보를 셋팅)
		MultiPartEmail email = new MultiPartEmail();
		email.setHostName("smtp.gmail.com");
		email.setSSL(true);
		email.setSmtpPort(465);
		
		// SMTP Server 정보 (현재 구글 메일 SMTP 사용중
		email.setAuthentication("xxxxx@gmail.com", "xxxxx");
		
		email.addTo(mailVO.getTo());
		email.setFrom(mailVO.getFrom(), mailVO.getName());
		email.setSubject(mailVO.getSubject());
		email.setMsg(mailVO.getMsg());

		// 생성한 attachment를 추가합니다
		email.attach(attachment);

		// 메일을 전송합니다
		email.send();
		return "success";

	}
	@RequestMapping(value = "/mail/mailSimple.do")
	public String mailSimpleAttachProcess(MailVO mailVO) throws Exception {
		
		// 기본 메일 정보를 생성합니다 (SMTP서버의 기본정보를 셋팅)
		MultiPartEmail email = new MultiPartEmail();
		email.setHostName("smtp.gmail.com");
		email.setSSL(true);
		email.setSmtpPort(465);
		
		// SMTP Server 정보 (현재 구글 메일 SMTP 사용중
		email.setAuthentication("xxxxx@gmail.com", "xxxxx");
		
		email.addTo(mailVO.getTo());
		email.setFrom(mailVO.getFrom(), mailVO.getName());
		email.setSubject(mailVO.getSubject());
		email.setMsg(mailVO.getMsg());

		// 메일을 전송합니다
		email.send();
		return "success";

	}

}
