package egovframework.rte.util.web.single.controllers;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

import egovframework.rte.util.fileupload.single.service.ByteArrayFileUploadBean;

/**
 * @Class Name : ByteArrayFileUploadController.java
 * @Description : Single Fileupload를 위한 TEST용 class
 * @Modification Information
 * @
 * @  수정일         수정자                   수정내용
 * @ -------    --------    ---------------------------
 * @ 2009.03.05     이동도          최초 생성
 *
 *  @author 실행환경 개발팀 이동도
 *  @since 2009.03.05
 *  @version 1.0
 *  @see
 *  
 *  Copyright (C) 2009 by MOPAS  All right reserved.
 */

@Controller("byteArrayFileUploadController")
public class ByteArrayFileUploadController {
    
	@RequestMapping(value = "/upload/byteArrayFileSingle.do")
    protected String onSubmit(HttpServletRequest request, HttpServletResponse response, Object command,
            BindException errors) throws Exception {
        
        /*
         * validate type of request and type of form backing object bean
         */
        Assert.state(request instanceof MultipartHttpServletRequest, "request !instanceof MultipartHttpServletRequest");
        Assert.state(command instanceof ByteArrayFileUploadBean, "command !instanceof ByteArrayFileUploadBean");
        
        /*
         * validate binding of text input field
         */
        ByteArrayFileUploadBean bean = (ByteArrayFileUploadBean) command;
        Assert.state(bean.getType().equals("byteArrayFileSingle"), "type != byteArrayFileSingle");
        
        /*
         * validate binding of uploaded file
         */        
        byte[] file = bean.getFile();
        Assert.notNull(file, "byte array file must not be null");
        
        return onSubmit(request, response, command, errors);
    }
    
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws ServletException {
        binder.registerCustomEditor(byte[].class, new ByteArrayMultipartFileEditor());
    }
    
}