/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;

class T4CCharAccessor
extends CharAccessor {
    T4CMAREngine mare;
    boolean underlyingLong = false;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Fri_Sep_29_09:42:29_PDT_2006";

    T4CCharAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, s, n2, bl);
        this.mare = t4CMAREngine;
        this.calculateSizeTmpByteArray();
    }

    T4CCharAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, int n7, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, bl, n2, n3, n4, n5, n6, s);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
        this.calculateSizeTmpByteArray();
        this.oacmxl = n7;
        if (this.oacmxl == -1) {
            this.underlyingLong = true;
            this.oacmxl = 4000;
        }
    }

    void processIndicator(int n) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n <= 0, n);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int n = this.indicatorIndex + this.lastRowProcessed;
        int n2 = this.lengthIndex + this.lastRowProcessed;
        byte[] byArray = this.statement.tmpByteArray;
        int n3 = this.columnIndex + this.lastRowProcessed * this.charLength;
        if (this.rowSpaceIndicator == null) {
            byte[] byArray2 = new byte[16000];
            this.mare.unmarshalCLR(byArray2, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n2] = 0;
            ++this.lastRowProcessed;
            if (this.mare.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        if (this.statement.maxFieldSize > 0) {
            this.mare.unmarshalCLR(byArray, 0, this.meta, this.statement.maxFieldSize);
        } else {
            this.mare.unmarshalCLR(byArray, 0, this.meta);
        }
        this.tmp[0] = this.meta[0];
        int n4 = 0;
        n4 = this.formOfUse == 2 ? this.statement.connection.conversion.NCHARBytesToJavaChars(byArray, 0, this.rowSpaceChar, n3 + 1, this.tmp, this.charLength - 1) : this.statement.connection.conversion.CHARBytesToJavaChars(byArray, 0, this.rowSpaceChar, n3 + 1, this.tmp, this.charLength - 1);
        this.rowSpaceChar[n3] = (char)(n4 * 2);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n2] = 0;
        } else {
            this.rowSpaceIndicator[n2] = (short)(this.meta[0] * 2);
            this.rowSpaceIndicator[n] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int n = this.lastRowProcessed == 0 ? this.statement.rowPrefetch : this.lastRowProcessed;
        int n2 = this.columnIndex + this.lastRowProcessed * this.charLength;
        int n3 = this.columnIndex + (n - 1) * this.charLength;
        int n4 = this.indicatorIndex + this.lastRowProcessed;
        int n5 = this.indicatorIndex + n - 1;
        int n6 = this.lengthIndex + this.lastRowProcessed;
        int n7 = this.lengthIndex + n - 1;
        short s = this.rowSpaceIndicator[n7];
        this.rowSpaceIndicator[n6] = s;
        this.rowSpaceIndicator[n4] = this.rowSpaceIndicator[n5];
        System.arraycopy(this.rowSpaceChar, n3, this.rowSpaceChar, n2, this.rowSpaceChar[n3] / 2 + 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n, int n2) throws SQLException {
        int n3 = this.columnIndex + (n2 - 1) * this.charLength;
        int n4 = this.columnIndexLastRow + (n - 1) * this.charLength;
        int n5 = this.indicatorIndex + n2 - 1;
        int n6 = this.indicatorIndexLastRow + n - 1;
        int n7 = this.lengthIndex + n2 - 1;
        int n8 = this.lengthIndexLastRow + n - 1;
        short s = sArray[n8];
        this.rowSpaceIndicator[n7] = s;
        this.rowSpaceIndicator[n5] = sArray[n6];
        if (s != 0) {
            System.arraycopy(cArray, n4, this.rowSpaceChar, n3, cArray[n4] / 2 + 1);
        }
    }

    void calculateSizeTmpByteArray() {
        int n = this.formOfUse == 2 ? (this.charLength - 1) * this.statement.connection.conversion.maxNCharSize : (this.charLength - 1) * this.statement.connection.conversion.cMaxCharSize;
        if (this.statement.sizeTmpByteArray < n) {
            this.statement.sizeTmpByteArray = n;
        }
    }

    String getString(int n) throws SQLException {
        String string = super.getString(n);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    Object getObject(int n) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n);
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(n);
                }
                case 4: {
                    return new Integer(this.getInt(n));
                }
                case -6: {
                    return new Byte(this.getByte(n));
                }
                case 5: {
                    return new Short(this.getShort(n));
                }
                case -7: 
                case 16: {
                    return new Boolean(this.getBoolean(n));
                }
                case -5: {
                    return new Long(this.getLong(n));
                }
                case 7: {
                    return new Float(this.getFloat(n));
                }
                case 6: 
                case 8: {
                    return new Double(this.getDouble(n));
                }
                case 91: {
                    return this.getDate(n);
                }
                case 92: {
                    return this.getTime(n);
                }
                case 93: {
                    return this.getTimestamp(n);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytes(n);
                }
            }
            DatabaseError.throwSqlException(4);
            return null;
        }
        return var2_2;
    }
}

